# Laravel Facebook Graph SDK

The Laravel Facebook Graph SDK is a powerful tool to aid developers in the integration of the [Facebook Graph SDK for PHP 8 projects](http://github.com/joelbutcher/facebook-graph-sdk-php-8). Whether you're developing a website with Facebook login, creating a Facebook Canvas app or Page tab, the Laravel Facebook Graph SDK, coupled with the Facebook Graph PHP 8 SDK, does all the heavy lifting for you making it as easy as possible to deeply integrate into the Facebook platform.

For installation & implementation instructions, look through the [Getting Started](./getting_started.md) guide, and then check out some of the examples below.

---

## Examples

The following examples demonstrate how you would accomplish common tasks with the Facebook SDK for PHP.

- **Authentication & Signed Requests**
  - [Facebook Login (OAuth 2.0)](./examples/facebook_login.md)
  - [Obtaining an access token from the SDK for JavaScript](./examples/access_token_from_javascript.md)
  - [Obtaining an access token within a Facebook Canvas context](./examples/access_token_from_canvas.md)
  - [Obtaining an access token within a Facebook Page tab context](./examples/access_token_from_page_tab.md)
- **User profile**
  - [Retrieve a user's profile](./examples/retrieve_user_profile.md)
  - [Post a link to a user's feed](./examples/post_links.md)
- **File Uploads**
  - [Upload a photo to a user's profile](./examples/upload_photo.md)
  - [Upload a video to a user's profile](./examples/upload_video.md)
- **Batch Requests**
  - [Sending requests in a batch](./examples/batch_request.md)
  - [Uploading files in a batch](./examples/batch_upload.md)
- **Pagination**
  - [Basic pagination](./examples/pagination_basic.md)

## API Reference

For a full list of classes, see the [API documentation on the Facebook Graph SDK for PHP 8reference page](https://github.com/joelbutcher/facebook-graph-sdk-php-8/blob/6.x/docs/reference.md).
