<?php $__env->startSection('main'); ?>
    <style type="text/css">
        .card {
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 8px;
            margin-top: 20px;
            background-color: #fff
        }

        .card-title {
            font-size: 18px;
            margin-bottom: 10px;
        }

        .card-status {
            margin: 10px 0;
        }
    </style>
    <div class="content-wrapper">
        <section class="content-header">
            <h1> <?php echo e(__('messages.admin.payment_gateway.title')); ?></h1>
            <ol class="breadcrumb">
                <li>
                    <a href="<?php echo e(url(LOGIN_USER_TYPE . '/dashboard')); ?>"> <i class="fa fa-dashboard"></i>
                        <?php echo e(__('messages.admin.home')); ?> </a>
                </li>
                <li>
                    <a href="<?php echo e(url(LOGIN_USER_TYPE . '/payment_gateway')); ?>">
                        <?php echo e(__('messages.admin.payment_gateway.title')); ?></a>
                </li>
                <li class="active"> <?php echo e(__('messages.admin.edit')); ?> </li>
            </ol>
        </section>
        <section class="content " style="margin-top: 20px; margin-bottom: 20px;">
            <div class="row">
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-body">
                            <?php $__currentLoopData = $gatewayLists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $site => $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $isEnabled = $gateway['fields']->firstWhere('name', 'is_enabled')['value'] ?? '0';
                                ?>


                                <div class="col-xs-6 col-sm-4 col-md-3">
                                    <div class="card clearfix">
                                        <div class="pull-left" style="width: 65%;">
                                            <div class="card-title"><?php echo e($site === 'Common' ? 'Payout Methods' : $site); ?>

                                            </div>

                                            <?php if($site !== 'Common'): ?>
                                                <!-- Status Badge -->
                                                <span class="label label-<?php echo e($isEnabled == '1' ? 'success' : 'default'); ?>">
                                                    <?php echo e($isEnabled == '1' ? 'Active' : 'Inactive'); ?>

                                                </span>
                                            <?php endif; ?>

                                            <br /><br />
                                            <button class="btn btn-primary btn-sm" data-toggle="modal"
                                                data-target="#modal-<?php echo e($gateway['id']); ?>">Edit</button>
                                        </div>
                                        <div class="pull-right" style="width: 30%;">
                                            <img src="<?php echo e(asset('images/gateways/' . strtolower($site) . '.svg')); ?>"
                                                onerror="this.onerror=null;this.src='<?php echo e(asset('images/gateways/' . strtolower($site) . '.png')); ?>';"
                                                alt="<?php echo e($site); ?>" style="max-width: 100%; height: auto;">
                                        </div>
                                    </div>
                                </div>


                                <!-- Modal -->
                                <div class="modal fade" id="modal-<?php echo e($gateway['id']); ?>" tabindex="-1" role="dialog">
                                    <div class="modal-dialog" role="document">

                                        <?php echo Form::open(['url' => route('gateway.update', $gateway['id']), 'method' => 'post']); ?>

                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title"><?php echo e($site === 'Common' ? 'Payout Methods' : $site); ?>

                                                    Payment Gateway</h4>
                                                <button type="button" class="close" data-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body">



                                                <?php $__currentLoopData = $gateway['fields']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="form-group">
                                                        <?php if($field['name'] != 'is_web_payment' && $field['name'] != 'trip_default'): ?>
                                                            <label><?php echo e(ucfirst(str_replace('_', ' ', $field['name']))); ?></label>
                                                        <?php endif; ?>
                                                        <?php if($field['type'] === 'boolean'): ?>
                                                            <?php if($field['name'] === 'is_enabled'): ?>
                                                                <select name="fields[<?php echo e($field['name']); ?>]"
                                                                    class="form-control">
                                                                    <option value="1"
                                                                        <?php echo e($field['value'] == '1' ? 'selected' : ''); ?>>
                                                                        Active
                                                                    </option>
                                                                    <option value="0"
                                                                        <?php echo e($field['value'] == '0' ? 'selected' : ''); ?>>
                                                                        Inactive
                                                                    </option>
                                                                </select>
                                                            <?php else: ?>
                                                                <select name="fields[<?php echo e($field['name']); ?>]"
                                                                    class="form-control">
                                                                    <option value="sandbox"
                                                                        <?php echo e($field['value'] == 'sandbox' ? 'selected' : ''); ?>>
                                                                        Sandbox
                                                                    </option>
                                                                    <option value="live"
                                                                        <?php echo e($field['value'] == 'live' ? 'selected' : ''); ?>>
                                                                        Live
                                                                    </option>
                                                                </select>
                                                            <?php endif; ?>
                                                        <?php elseif($field['type'] === 'checkbox'): ?>
                                                            <?php
                                                                $selectedMethods = explode(',', $field['value']);
                                                            ?>
                                                            <div class="row">
                                                                <?php $__currentLoopData = PAYOUT_METHODS; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payout_method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <div class="col-lg-4 col-md-4 col-sm-6">
                                                                        <label
                                                                            for="payout_method-<?php echo e($payout_method['key']); ?>">
                                                                            <input type="checkbox"
                                                                                name="fields[<?php echo e($field['name']); ?>][]"
                                                                                value="<?php echo e($payout_method['key']); ?>"
                                                                                <?php echo e(in_array($payout_method['key'], $selectedMethods) ? 'checked' : ''); ?>>

                                                                            <?php echo e($payout_method['value']); ?> </label>
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </div>
                                                        <?php else: ?>
                                                            <?php if($field['name'] != 'is_web_payment' && $field['name'] != 'trip_default'): ?>
                                                                <input type="text" name="fields[<?php echo e($field['name']); ?>]"
                                                                    class="form-control" value="<?php echo e($field['value']); ?>">
                                                            
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                            </div>
                                            <div class="modal-footer">
                                                <button type="submit" class="btn btn-success">Save</button>
                                                <button type="button" class="btn btn-default"
                                                    data-dismiss="modal">Cancel</button>
                                            </div>
                                        </div>
                                        <?php echo Form::close(); ?>

                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            <?php $__env->stopSection(); ?>

            <?php $__env->startPush('scripts'); ?>
                <script>
                    $('#editModal').on('show.bs.modal', function(event) {
                        var button = $(event.relatedTarget);
                        var id = button.data('id');
                        var site = button.data('site');
                        var name = button.data('name');
                        var value = button.data('value');

                        var modal = $(this);
                        modal.find('#modal-id').val(id);
                        modal.find('#modal-site').val(site);
                        modal.find('#modal-value').val(value);
                    });
                </script>
            <?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\ridein25\resources\views/admin/payment_gateway.blade.php ENDPATH**/ ?>