<!DOCTYPE html>
<html>

<head>
    <title>Payment</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0" />

    <link media="all" type="text/css" rel="stylesheet" href="{{ asset('css/payment.css') }}" />
</head>


<body ng-app="App" class="">

    <main>
        <div class="payment-form" id="theme">


            <div class="main-header-content">
                <div class="left-div">
                  <!-- Content for the left div -->
              <small> <b>Customer Name:</b> {{$user_name}}</small>
                </div>
                <div class="right-div">
                  <!-- Content for the right div -->
               <small><b>Mobile Number:</b> +{{$user_country_code}}{{$user_phone}}</small>
                </div>
              </div>


            <div class="main-header">
                <div>{{ $currency_code }} {{ $amount }}</div>
            </div>


            @foreach ($view as $key => $paymet_methods)
                @if ($payment_name === 'Redsys' || $payment_name === 'redsys')
                    @include($paymet_methods['view'], [
                        'data' => ['currency_code' => $currency_code, 'amount' => $amount] + $paymet_methods,
                    ])
                @else
                    <form id="checkout_payment" method="post" action="{{ route('payment.success') }}">
                        <input type="hidden" name="pay_key" id="nonce">
                        <input type="hidden" name="payment_type" id="payment_type">
                        <div class="row">
                            @if ($loop->even)
                                <span style="text-align: center;">OR</span>
                            @endif
                            @include($paymet_methods['view'], [
                                'data' =>
                                    ['currency_code' => $currency_code, 'amount' => $amount] + $paymet_methods,
                            ])
                        </div>
                    </form>
                @endif
            @endforeach


        </div>
    </main>
</body>




{!! Html::script('js/jquery-1.11.3.js') !!}
{!! Html::script('js/jquery-ui.js') !!}
{!! Html::script('js/angular.js') !!}
{!! Html::script('js/angular-sanitize.js') !!}

<script>
    var app = angular.module('App', ['ngSanitize']);
    var APP_URL = {!! json_encode(url('/')) !!};

    // Get URL to Create Dark theme
    const urlParams = new URLSearchParams(window.location.search);
    const myParam = urlParams.get('mode');
    var element = document.getElementById("theme");
    element.classList.add(myParam);
</script>

@if (request('payment_type') == 'Yo')
    <script>
        $(document).ready(function() {
            $('#checkout_payment').on('submit', function(e) {
                // Prevent form submission to test the functionality
                e.preventDefault();

                const button = $('#submitButton');
                const buttonText = button.text().trim();

                // Check if the button text is "Pay Now"
                    button.text('Processing Payments...');
                    button.prop('disabled', true); // Disable the button to prevent multiple submissions

                // Optionally submit the form after setting the text
                this.submit();
            });
        });
    </script>
@endif



@stack('scripts')

</html>
