<?php

/**
 * Mtn Payout Service
 *
 * @package     Ridein
 * @subpackage  Services\Payouts
 * @category    Yo Payments
 * @author      Source monster Team
 * @version     3.8.0
 * @link        https://sourcemonster.in
 */

namespace App\Services\Payouts;

use App\Models\Country;
use App\Models\Currency;
use App\Models\Transaction;
use Bmatovu\MtnMomo\Exceptions\CollectionRequestException;
use Illuminate\Support\Facades\Config;
use Tymon\JWTAuth\Facades\JWTAuth;
use Bmatovu\MtnMomo\Products\Disbursement;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Log;
use YoAPI;


class YoPayout
{
    private $yoAPI;
    public $defaultPhoneNumber = '';

    /**
     * Intialize Stripe with Secret key
     *
     */
    public function __construct()
    {
        $api_username =  payment_gateway('username', 'Yo');
        $api_password = payment_gateway('password', 'Yo');
        $mode = payment_gateway('mode', 'Yo');

        $this->yoAPI = new YoAPI($api_username, $api_password, $mode);
    }

    /**
     * Get Current Login User based on request segment
     *
     * @return $user instance of User
     */
    protected function getCurrentUser()
    {
        if (isApiRequest()) {
            return JWTAuth::parseToken()->authenticate();
        }
        if (request()->segment(1) == 'company') {
            return auth('company')->user();
        }
        return auth()->user();
    }


    /**
     * validate Request
     *
     * @param Request $[request]
     * @return Mixed
     */
    public function validateRequest($request)
    {
        $rules = array(
            'phone_number' => 'required|numeric',
        );

        $messages = array(
            'required' => ':attribute ' . trans('messages.home.field_is_required'),
        );
        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            if (isApiRequest()) {
                return response()->json([
                    'status_code' => '0',
                    'status_message' => $validator->messages()->first(),
                ]);
            }
            return back()->withErrors($validator)->withInput();
        }
        return false;
    }



    public function makePayout($payout_id, $pay_data)
    {
        try {

            if (payment_gateway('mode', 'Yo') === 'sandbox') {
                $this->defaultPhoneNumber = '256770000000';//770000000
            } else {
                $this->defaultPhoneNumber  = $payout_id ? $payout_id : $pay_data['mobile_number'];
            }

            $narrative = 'ac_withdraw_funds payments test with public key authentication signature';
            $response = $this->yoAPI->ac_withdraw_funds( $this->defaultPhoneNumber,$pay_data['amount'], $narrative);

              //save transaction
              $transaction = new Transaction();
              $transaction->payment_method = 'Mtn Mobile Money';
              $transaction->payment_purpose = 'Payout';
              $transaction->user_id = $pay_data['user_id'];
              $transaction->amount = $pay_data['amount'];
              $transaction->tel = $pay_data['mobile_number'];

            if ($response['TransactionStatus'] == 'SUCCEEDED') {
                echo "Payment made! Funds have been deposited onto your account. Transaction Reference = " . $response['TransactionReference'] . ". Thank you for using Yo! Payments";
                // Save this transaction for future reference
                $transaction->status = 'completed'; //pending,failed,completed
                $transaction->reference = $response['TransactionReference'];
                $transaction->momo_transaction_id = $response['MNOTransactionReferenceId'];
                $transaction->save();

                return array(
                    'status' => true,
                    'status_message' => 'Payout amount has transferred successfully',
                    'transaction_id' =>  $response['TransactionReference'],
                    'is_pending' => false
                );

            } else {
                echo "Yo Payments Error: " . $response['StatusMessage'];
                $transaction->status = 'failed'; //pending,failed,completed
                $transaction->save();

                return array(
                    'status' => false,
                    'status_message' => 'Payout amount has transferred failed',
                    'transaction_id' => '',
                    'is_pending' => false
                );
            }
        } catch (\Exception $e) {
            return array(
                'status' => false,
                'status_message' => $e->getMessage(),
            );
        }

        return array(
            'status' => true,
            'status_message' => 'Payout amount has transferred successfully',
            'transaction_id' => $response->id,
        );
    }
}
