<?php

/**
 *  Flutterwave Service
 *
 * @package     Ridein
 * @subpackage  Services\Payments
 * @category    Mpesa
 * @author      Sourcemonster Team
 * @version      3.3.9
 * @link        https://sourcemonster.in
 */



namespace App\Services\Payments;

use App\Services\PaymentMethods\MpesaPayment as MpesaGateway;
use App\Contracts\PaymentInterface;

class MpesaPayment  extends MpesaGateway implements PaymentInterface
{


    public function view()
    {
       
        return array('view' => 'payment.mpesa');
    }

    public function Payment($paymentData,$accessToken)
    {   
        $responce = $this->makePayment($paymentData,$accessToken);
        
        
        return $this->returnResponse($responce);

    }

    public function Verify($requestData){
        $responce = $this->paymentVerify($requestData);
        return $this->returnResponse($responce);
    }

    
    public function returnResponse($responce)
    {
      $responce->status_code =  $responce->status ? "1":"0";
      return $responce;
    }

}
