<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{

    protected $fillable = ['user_id', 'amount','pay_for', 'tel', 'status','applied_referral_amount', 'payment_purpose', 'payment_method', 'reference', 'transaction_id', 'momo_transaction_id','is_charges','currency','trip_id','payment_type','checkout_request_id','merchant_request_id'];

    protected $table = 'transactions';

    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
