<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Admin Panel</title>
		<link rel="shortcut icon" href="<?php echo e($favicon); ?>">
		<!-- Tell the browser to be responsive to screen width -->
		<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
		<!-- Bootstrap 3.3.5 -->
		<link rel="stylesheet" href="<?php echo e(url('admin_assets/bootstrap/css/bootstrap.min.css')); ?>">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css">
		<!-- Ionicons -->
		<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
		<!-- Theme style -->
		<link rel="stylesheet" href="<?php echo e(url('admin_assets/dist/css/AdminLTE.css')); ?>">

		<link rel="stylesheet" href="<?php echo e(url('admin_assets/plugins/login_slider/bootstrap.min.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(url('admin_assets/plugins/login_slider/style.css')); ?>">
		<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
	</head>
	<body class="hold-transition login-page">
		<div class="flash-container" style="left:15px;">
			<?php if(Session::has('message') && !Auth::guard('admin')->check()): ?>
			<div class="alert <?php echo e(Session::get('alert-class')); ?>" role="alert">
				<a href="#" class="alert-close" data-dismiss="alert"></a>
				<?php echo e(Session::get('message')); ?>

			</div>
			<?php endif; ?>
		</div>
		<div class="login-box">
			<div class="register-container">
				<div class="register">
					<form action="<?php echo e(url('admin/authenticate')); ?>" method="post">
						<?php echo Form::token(); ?>

						<h2>LOGIN TO <span class="red"><strong><?php echo e($site_name); ?></strong></span></h2>
						<div class="login-tabs">
							<ul>
								<li class="btn login_btn <?php echo e(old('user_type','Admin')=='Admin'?'active':''); ?>" user="Admin">
									Admin
								</li>
								<li class="btn login_btn <?php echo e(old('user_type','Admin')=='Dispatcher'?'active':''); ?>" user="Dispatcher">
									Dispatcher
								</li>
								<li class="btn login_btn <?php echo e(old('user_type','Admin')=='Company'?'active':''); ?>" user="Company">
									Company
								</li>
							</ul>
							<div class="tab-content">
								<input type="hidden" name="user_type" class="user_type" value="Admin">
								<div class="form-group">
									<label for="username" label="Username" class="username_label">Username</label>
									<input type="text" id="username" value="" name="username" placeholder="Enter the username">
								</div>
								<div class="form-group">
									<label for="password">Password</label>
									<input type="password" id="password" value="<?php echo e(canDisplayCredentials() ? '123456':''); ?>" name="password" placeholder="Enter the password">
								</div>
							</div>
						</div>
						<button type="submit">LOGIN</button>
					</form>
				</div>
			</div>
		</div>
		<!-- /.login-box -->
		<!-- jQuery 2.1.4 -->
		<script src="<?php echo e(url('admin_assets/plugins/jQuery/jQuery-2.1.4.min.js')); ?>"></script>
		<!-- Bootstrap 3.3.5 -->
		<script src="<?php echo e(url('admin_assets/bootstrap/js/bootstrap.min.js')); ?>"></script>
		<script src="<?php echo e(url('admin_assets/plugins/login_slider/scripts.js')); ?>"></script>
		<script src="<?php echo e(url('admin_assets/plugins/login_slider/jquery.backstretch.min.js')); ?>"></script>
		<script>
		$(document).ready(function() {
			var canDisplayCredentials = '<?php echo canDisplayCredentials(); ?>';
			$('.login_btn').click(function() {
				$('.login_btn').removeClass('active')
				$(this).addClass('active')
				login_change();
			});
			login_change();
			function login_change() {
				user = $('.login_btn.active').attr('user')
				$('.user_type').val(user);
				if (user == 'Admin') {
					if(canDisplayCredentials == '1') {
						$('#username').val('admin');
					}
					$('#username').attr('placeholder','Username');
					$('.username_label').text('Username');
					$(".username_label").attr('label','Username');
				}
				else if(user == 'Dispatcher') {
					if(canDisplayCredentials == '1') {
						$('#username').val('dispatcher');
					}
					$('#username').attr('placeholder','Username');
					$('.username_label').text('Username');
					$(".username_label").attr('label','Username');
				}
				else if(user == 'Company') {
					if(canDisplayCredentials == '1') {
						$('#username').val('9876543211');
					}
					$('#username').attr('placeholder','Email / Mobile Number');
					$('.username_label').text('Email / Mobile Number');
					$(".username_label").attr('label','Email / Mobile Number');
				}
			}
		});
		</script>
		<style type="text/css">
			.login_panel {
				display: none;
			}
			.login_panel.active {
				display: block;
			}
		</style>
	</body>
</html>
<?php /**PATH /var/www/html/projects/codecayon-ridein/resources/views/admin/login.blade.php ENDPATH**/ ?>