@extends('admin.template')
@section('main')
    <style type="text/css">
        .card {
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 8px;
            margin-top: 20px;
            background-color: #fff
        }

        .card-title {
            font-size: 18px;
            margin-bottom: 10px;
        }

        .card-status {
            margin: 10px 0;
        }
    </style>
    <div class="content-wrapper">
        <section class="content-header">
            <h1> {{ __('messages.admin.payment_gateway.title') }}</h1>
            <ol class="breadcrumb">
                <li>
                    <a href="{{ url(LOGIN_USER_TYPE . '/dashboard') }}"> <i class="fa fa-dashboard"></i>
                        {{ __('messages.admin.home') }} </a>
                </li>
                <li>
                    <a href="{{ url(LOGIN_USER_TYPE . '/payment_gateway') }}">
                        {{ __('messages.admin.payment_gateway.title') }}</a>
                </li>
                <li class="active"> {{ __('messages.admin.edit') }} </li>
            </ol>
        </section>
        <section class="content " style="margin-top: 20px; margin-bottom: 20px;">
            <div class="row">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-body">
                            @foreach ($gatewayLists as $site => $gateway)
                                @php
                                    $isEnabled = $gateway['fields']->firstWhere('name', 'is_enabled')['value'] ?? '0';
                                @endphp


                                <div class="col-xs-6 col-sm-4 col-md-3">
                                    <div class="card clearfix">
                                        <div class="pull-left" style="width: 65%;">
                                            <div class="card-title">{{ $site === 'Common' ? 'Payout Methods' : $site }}
                                            </div>

                                            @if ($site !== 'Common')
                                                <!-- Status Badge -->
                                                <span class="label label-{{ $isEnabled == '1' ? 'success' : 'default' }}">
                                                    {{ $isEnabled == '1' ? 'Active' : 'Inactive' }}
                                                </span>
                                            @endif

                                            <br /><br />
                                            <button class="btn btn-primary btn-sm" data-toggle="modal"
                                                data-target="#modal-{{ $gateway['id'] }}">Edit</button>
                                        </div>
                                        <div class="pull-right" style="width: 30%;">
                                            <img src="{{ asset('images/gateways/' . strtolower($site) . '.svg') }}"
                                                onerror="this.onerror=null;this.src='{{ asset('images/gateways/' . strtolower($site) . '.png') }}';"
                                                alt="{{ $site }}" style="max-width: 100%; height: auto;">
                                        </div>
                                    </div>
                                </div>


                                <!-- Modal -->
                                <div class="modal fade" id="modal-{{ $gateway['id'] }}" tabindex="-1" role="dialog">
                                    <div class="modal-dialog" role="document">

                                        {!! Form::open(['url' => route('gateway.update', $gateway['id']), 'method' => 'post']) !!}
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title">{{ $site === 'Common' ? 'Payout Methods' : $site }}
                                                    Payment Gateway</h4>
                                                <button type="button" class="close" data-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body">



                                                @foreach ($gateway['fields'] as $field)
                                                    <div class="form-group">
                                                        @if ($field['name'] != 'is_web_payment' && $field['name'] != 'trip_default')
                                                            <label>{{ ucfirst(str_replace('_', ' ', $field['name'])) }}</label>
                                                        @endif
                                                        @if ($field['type'] === 'boolean')
                                                            @if ($field['name'] === 'is_enabled')
                                                                <select name="fields[{{ $field['name'] }}]"
                                                                    class="form-control">
                                                                    <option value="1"
                                                                        {{ $field['value'] == '1' ? 'selected' : '' }}>
                                                                        Active
                                                                    </option>
                                                                    <option value="0"
                                                                        {{ $field['value'] == '0' ? 'selected' : '' }}>
                                                                        Inactive
                                                                    </option>
                                                                </select>
                                                            @else
                                                                <select name="fields[{{ $field['name'] }}]"
                                                                    class="form-control">
                                                                    <option value="sandbox"
                                                                        {{ $field['value'] == 'sandbox' ? 'selected' : '' }}>
                                                                        Sandbox
                                                                    </option>
                                                                    <option value="live"
                                                                        {{ $field['value'] == 'live' ? 'selected' : '' }}>
                                                                        Live
                                                                    </option>
                                                                </select>
                                                            @endif
                                                        @elseif ($field['type'] === 'checkbox')
                                                            @php
                                                                $selectedMethods = explode(',', $field['value']);
                                                            @endphp
                                                            <div class="row">
                                                                @foreach (PAYOUT_METHODS as $payout_method)
                                                                    <div class="col-lg-4 col-md-4 col-sm-6">
                                                                        <label
                                                                            for="payout_method-{{ $payout_method['key'] }}">
                                                                            <input type="checkbox"
                                                                                name="fields[{{ $field['name'] }}][]"
                                                                                value="{{ $payout_method['key'] }}"
                                                                                {{ in_array($payout_method['key'], $selectedMethods) ? 'checked' : '' }}>

                                                                            {{ $payout_method['value'] }} </label>
                                                                    </div>
                                                                @endforeach
                                                            </div>
                                                        @else
                                                            @if ($field['name'] != 'is_web_payment' && $field['name'] != 'trip_default')
                                                                <input type="text" name="fields[{{ $field['name'] }}]"
                                                                    class="form-control" value="{{ $field['value'] }}">
                                                            
                                                            @endif
                                                        @endif
                                                    </div>
                                                @endforeach


                                            </div>
                                            <div class="modal-footer">
                                                <button type="submit" class="btn btn-success">Save</button>
                                                <button type="button" class="btn btn-default"
                                                    data-dismiss="modal">Cancel</button>
                                            </div>
                                        </div>
                                        {!! Form::close() !!}
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endsection

            @push('scripts')
                <script>
                    $('#editModal').on('show.bs.modal', function(event) {
                        var button = $(event.relatedTarget);
                        var id = button.data('id');
                        var site = button.data('site');
                        var name = button.data('name');
                        var value = button.data('value');

                        var modal = $(this);
                        modal.find('#modal-id').val(id);
                        modal.find('#modal-site').val(site);
                        modal.find('#modal-value').val(value);
                    });
                </script>
            @endpush
