<?php

/**
 * Mpesa Payout Service
 *
 * @package     RIdein
 * @subpackage  Services\Payouts
 * @category    Mpesa
 * @author      Source monster Team
 * @version     2.2.1
 * @link        https://sourcemonster.in
 */

namespace App\Services\Payouts;

use App\Models\Country;
use App\Models\Transaction;
use Exception;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;


class MpesaPayout
{
    public $mode;
    public $url;
    public $publicKey;
    public $initiatorName;
    public $initatorPassword;
    public $consumer_key = '';
    public $consumer_secret = '';
    public $command;
    public $business_code;
    public $defaultPhoneNumber;



    public function __construct()
    {
        $this->consumer_key =  payment_gateway('consumer_key', 'Mpesa');
        $this->consumer_secret =  payment_gateway('consumer_secret', 'Mpesa');
        $this->business_code =  payment_gateway('business_shortcode', 'Mpesa');
        $this->mode = payment_gateway('mode', 'Mpesa');
        $this->initiatorName = payment_gateway('initiator_name', 'Mpesa');
        $this->initatorPassword = payment_gateway('initiator_password', 'Mpesa');

        $this->publicKey = Storage::disk('local')->get("certs/{$this->mode}/{$this->mode}.cer");
        $this->url =    $this->mode == 'sandbox'
            ? 'https://sandbox.safaricom.co.ke'
            : 'https://api.safaricom.co.ke';

        $this->command = 'BusinessPayment';
    }



    public function makePayout($payout_id, $pay_data)
    {
        try {

            if ($this->mode === 'sandbox') {
                $this->defaultPhoneNumber = '254708374149';
            } else {
                $this->defaultPhoneNumber  = $pay_data['mobile_number'];
            }
            openssl_public_encrypt($this->initatorPassword, $encrypted, $this->publicKey, OPENSSL_PKCS1_PADDING);
            $sandboxPassword = 'UNPMpfrhSfSeqN566HAlAQYaIQMeLvpEPZ5SiUR5pJn4faGYBnye251wCLGR56B3uOtT39UmoSeHtFhIa3torjhkXsfESm5NvKhIIOnHKa5Ry3rzeVxL+ruZE2st80HCLsbsJUQmvJ8vbE+h+NamH4DJi7JFHrHAPJ06BPjZuQEYbd/Lei1q4sdmQg6c38ZAnPIrvvWWidqxWc+uspbjqC+Dcyy6o9uwkfCCYGkvLtA8n2FM8MZazh/wgVjBOSV/RMmnt/cZjqoAiUVTkW6FMac77w1ejhweN4khV9mhmZvjmfaFmYi54nXbLSOC8FvkyiJf8uecNSAyWb5G/IhpaQ==';
            $password = ($this->mode == 'live') ? base64_encode($encrypted) : $sandboxPassword;

            $remarks = 'remarks';
            $occasion = 'occassion';
            $curl_post_data = [
                'InitiatorName' =>   $this->initiatorName,
                'SecurityCredential' => $password,
                'CommandID' => $this->command,
                'Amount' => $pay_data['amount'],
                'PartyA' =>   $this->business_code,
                'PartyB' => $this->defaultPhoneNumber,
                'Remarks' => $remarks,
                'QueueTimeOutURL' => route('payout.b2c_timeout'), 'https://4240-2400-1a00-bb20-6161-e95c-8b8b-e49e-cfd9.ngrok-free.app/admin/payout_b2c_timeout',
                'ResultURL' => route('payout.b2c_result'), "https://4240-2400-1a00-bb20-6161-e95c-8b8b-e49e-cfd9.ngrok-free.app/admin/payout_b2c_result",
                'Occasion' => $occasion,
            ];


            $token = $this->token();
            $curl = curl_init();
            $data_string = json_encode($curl_post_data);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLOPT_URL,  $this->url . '/mpesa/b2c/v1/paymentrequest');
            curl_setopt(
                $curl,
                CURLOPT_HTTPHEADER,
                [
                    'Content-Type:application/json',
                    'Authorization:Bearer ' . $token,
                ]
            );

            $response = curl_exec($curl);

            $result = json_decode($response, true);
            if ($result['ResponseCode'] == '0') {

                $transaction = new Transaction();
                $transaction->currency = $pay_data['currency'];
                $transaction->user_id = $pay_data['user_id'];
                $transaction->payment_type = 'Mpesa';
                $transaction->amount = $pay_data['amount'];
                $transaction->pay_for = 'payout';
                $transaction->conversation_id = $result['ConversationID'];
                $transaction->save();

                return array(
                    'status' => true,
                    'is_pending' => true,
                    'transaction_id'=>$result['ConversationID'],
                    'status_message' => $result['ResponseDescription'],
                );
            } else {
                return array(
                    'status' => false,
                    'status_message' => 'service request failed',
                );
            }
        } catch (Exception  $e) {
            return array(
                'status' => false,
                'status_message' => $e->getMessage(),
            );
        }
    }

    public function token()
    {
        $mpesa_payment = resolve('App\Services\PaymentMethods\MpesaPayment');
        $generateAccessToken =  $mpesa_payment->generateAccessToken();
        return  $generateAccessToken->status ?  $generateAccessToken->access_token : '';
    }

    public function timeout()
    {
        $data = file_get_contents('php://input');
        Storage::disk('local')->put('b2ctimeout.txt', $data);
    }



       /**
     * validate Request
     *
     * @param Request $[request]
     * @return Mixed
     */
    public function validateRequest($request)
    {
        $rules = array(
            'mpesa_tel' => 'required|numeric',
        );

        $messages = array(
            'required' => ':attribute '.trans('messages.home.field_is_required'),
        );
        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            if(isApiRequest()) {
                return response()->json([
                    'status_code' => '0',
                    'status_message' => $validator->messages()->first(),
                ]);
            }
            return back()->withErrors($validator)->withInput();
        }
        return false;
    }

}
